<?php $__env->startSection('content'); ?>
  <?php echo \Illuminate\View\Factory::parentPlaceholder('content'); ?>

  <?php echo $__env->make('accounts.nav', ['selected' => ACCOUNT_TAX_RATES], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <?php echo Former::open()->addClass('warn-on-exit'); ?>

  <?php echo e(Former::populate($account)); ?>

  <?php echo e(Former::populateField('invoice_taxes', intval($account->invoice_taxes))); ?>

  <?php echo e(Former::populateField('invoice_item_taxes', intval($account->invoice_item_taxes))); ?>

  <?php echo e(Former::populateField('enable_second_tax_rate', intval($account->enable_second_tax_rate))); ?>

  <?php echo e(Former::populateField('include_item_taxes_inline', intval($account->include_item_taxes_inline))); ?>

  <?php echo e(Former::populateField('inclusive_taxes', intval($account->inclusive_taxes))); ?>



  <div class="panel panel-default">
  <div class="panel-heading">
    <h3 class="panel-title"><?php echo trans('texts.tax_settings'); ?></h3>
  </div>
  <div class="panel-body">

    <?php echo Former::checkbox('invoice_taxes')
        ->text(trans('texts.enable_invoice_tax'))
        ->label('&nbsp;')
        ->value(1); ?>


    <?php echo Former::checkbox('invoice_item_taxes')
        ->text(trans('texts.enable_line_item_tax'))
        ->label('&nbsp;')
        ->value(1); ?>


    <?php echo Former::checkbox('enable_second_tax_rate')
        ->text(trans('texts.enable_second_tax_rate'))
        ->label('&nbsp;')
        ->value(1); ?>


    <?php echo Former::checkbox('include_item_taxes_inline')
        ->text(trans('texts.include_item_taxes_inline'))
        ->label('&nbsp;')
        ->value(1); ?>


    <?php if(! $hasInclusiveTaxRates && $countInvoices == 0): ?>
        <br/>
        <br/>
        <?php echo Former::checkbox('inclusive_taxes')
            ->text(trans('texts.inclusive_taxes_help'))
            ->label('&nbsp;')
            ->help('<b>' . strtoupper(trans('texts.important')) . ': '
                . trans('texts.inclusive_taxes_notice') . '</b>')
            ->value(1); ?>

    <?php elseif($countInvoices <= 10): ?>
        <?php echo Former::plaintext(' ')->help(
                trans($account->inclusive_taxes ? 'texts.taxes_are_included_help' : 'texts.taxes_are_not_included_help') . '<br/>' .
                trans('texts.change_requires_purge', ['link' => link_to(url('/settings/account_management'), trans('texts.purging'))])); ?>

    <?php else: ?>
        <?php echo Former::plaintext(' ')->help(
                trans($account->inclusive_taxes ? 'texts.taxes_are_included_help' : 'texts.taxes_are_not_included_help')); ?>

    <?php endif; ?>

      &nbsp;

      <?php if($taxRates->count()): ?>
          <?php echo $__env->make('partials.tax_rates', ['taxRateLabel' => trans('texts.default_tax_rate_id')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
          &nbsp;
      <?php endif; ?>

      <?php echo Former::actions( Button::success(trans('texts.save'))->submit()->appendIcon(Icon::create('floppy-disk')) ); ?>

      <?php echo Former::close(); ?>

  </div>
  </div>

  <?php echo Button::primary(trans('texts.create_tax_rate'))
        ->asLinkTo(URL::to('/tax_rates/create'))
        ->withAttributes(['class' => 'pull-right'])
        ->appendIcon(Icon::create('plus-sign')); ?>


  <?php echo $__env->make('partials.bulk_form', ['entityType' => ENTITY_TAX_RATE], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <?php echo Datatable::table()
      ->addColumn(
        trans('texts.name'),
        trans('texts.rate'),
        trans('texts.type'),
        trans('texts.action'))
      ->setUrl(url('api/tax_rates/'))
      ->setOptions('sPaginationType', 'bootstrap')
      ->setOptions('bFilter', false)
      ->setOptions('bAutoWidth', false)
      ->setOptions('aoColumns', [[ "sWidth"=> "25%" ], [ "sWidth"=> "25%" ], ["sWidth"=> "25%"], ["sWidth"=> "25%"]])
      ->setOptions('aoColumnDefs', [['bSortable'=>false, 'aTargets'=>[2]]])
      ->render('datatable'); ?>


  <script>
    window.onDatatableReady = actionListHandler;
  </script>


  <script type="text/javascript">
    $(function() {
        <?php if($countInvoices > 0): ?>
            $('#inclusive_taxes').change(function() {
                swal("<?php echo e(trans('texts.inclusive_taxes_warning')); ?>");
            })
        <?php endif; ?>
    })
  </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/markosico/public_html/bills/resources/views/accounts/tax_rates.blade.php ENDPATH**/ ?>